package parser;

/**
 * Factory for F grammar non-terminal objects.
 */
public class FFact extends ATVFactory {
    /**
     * Factory for I grammar non-terminal visitors.
     */
    IFact _iFact;

    /**
     * Factory for N grammar non-terminal visitors.
     */
    NFact _nFact;

    /**
     * Constructor for the F factory,
     *
     * @param tkz   tokenizer to use
     * @param iFact factory for I non-terminal visitors
     * @param nFact factory for N non-terminal visitors
     */
    public FFact(ITokenizer tkz, IFact iFact, NFact nFact) {
        super(tkz);
        _iFact = iFact;
        _nFact = nFact;
    }

    /**
     * Make a token visitor to parse an F non-terminal.
     *
     * @return token visitor
     */
    public ITokVisitor makeVisitor() {
        return _iFact.makeChainedVisitor(_nFact.makeVisitor());
    }

    /**
     * Make a token visitor that delegates to the given visitor in a chain of responsibility.
     *
     * @param successor visitor to serve as successor in the chain
     */
    public ITokVisitor makeChainedVisitor(final ITokVisitor successor) {
        return _iFact.makeChainedVisitor(_nFact.makeChainedVisitor(successor));
    }


    /**
     * Make a token visitor that delegates to the given visitor in a chain of responsibility.
     *
     * @param successor       visitor to serve as successor in the chain
     * @param successorLambda lambda to pass to the successor in the default case
     */
    public ITokVisitor makeBacktrackChainedVisitor(ITokVisitor successor, ILambda successorLambda) {
        return _iFact.makeChainedVisitor(_nFact.makeBacktrackChainedVisitor(successor, successorLambda));
    }
}

